var AjaxPoll = {
	init: function(){
		AjaxPoll.initVote();
		AjaxPoll.initUndo();
		AjaxPoll.initShow();
	},
	
	showOverlay: function(){
		var overlay = null;
		if($('ajaxpoll_overlay'))
		{
			overlay = $('ajaxpoll_overlay');
		}
		else
		{
			overlay = new Element('div');
			overlay.id = 'ajaxpoll_overlay';
			overlay.setStyle({
				backgroundColor: 'white',
				position: 'absolute'
			});
			overlay.setOpacity(0.8);

			var spinner = new Element('img');
			spinner.src = AJAXPOLL_SPINNER;
			spinner.setStyle({
				position: 'absolute',
				top: '50%',
				left: '50%',
				marginLeft: '-35px',
				marginTop: '-35px'
			});
			overlay.insert(spinner);
			overlay.hide();
			
			document.body.appendChild(overlay);
		}
		
		// workaround for IE7 bug
		try
		{
			overlay.clonePosition('ajaxpoll');
		}
		catch(e)
		{
			overlay.clonePosition('ajaxpoll');
		}
		
		overlay.setStyle({
			lineHeight: overlay.style.height
		});
		overlay.show();
	},
	
	hideOverlay: function(){
		if($('ajaxpoll_overlay'))
		{
			$('ajaxpoll_overlay').hide();
		}
	},
	
	initVote: function(){
		$$('#ajaxpoll form')
			.invoke('stopObserving', 'submit')
			.invoke('observe', 'submit', function(e){
				AjaxPoll.showOverlay();
				
				var url = this.readAttribute('action');
				url += url.indexOf('?') == -1 ? "?" : "&";
				url += this.serialize();
				url += "&ajax=1";
				
				new Ajax.Request(url,{
					method: 'get',
					onSuccess: function(transport){
						if(transport.responseText.match(/<error>(.*)<\/error>/))
						{
							message = transport.responseText.match(/<error>(.*)<\/error>/);
							if(!message[1])
							{
								message[1] = "An unknown error occurred.";
							}
							
							alert(message[1]);
							AjaxPoll.hideOverlay();
						}
						else
						{
							AjaxPoll.hideOverlay();
							$('ajaxpoll').replace(transport.responseText);
							AjaxPoll.initUndo();
							AjaxPoll.initShow();
						}
					}
				});
				
				Event.stop(e);
			});
	},
	
	initUndo: function(){
		$$('#ajaxpoll a[href^=polls.php?action=do_undovote]')
			.invoke('stopObserving','click')
			.invoke('observe','click',function(e){
				AjaxPoll.showOverlay();
			
				var url = this.readAttribute('href');
				url += "&ajax=1";
				
				new Ajax.Request(url,{
					method: 'get',
					onSuccess: function(transport){
						if(transport.responseText.match(/<error>(.*)<\/error>/))
						{
							message = transport.responseText.match(/<error>(.*)<\/error>/);
							if(!message[1])
							{
								message[1] = "An unknown error occurred.";
							}
							
							alert(message[1]);
							AjaxPoll.hideOverlay();
						}
						else
						{
							AjaxPoll.hideOverlay();
							$('ajaxpoll').replace(transport.responseText);
							AjaxPoll.initVote();
							AjaxPoll.initShow();
						}
					}
				});
				
				Event.stop(e);
			});
	},
	
	initShow: function(){
		$$('#ajaxpoll a[href^=polls.php?action=showresults]')
			.invoke('stopObserving','click')
			.invoke('observe','click',function(e){
				AjaxPoll.showOverlay();
			
				var url = this.readAttribute('href');
				url += "&ajax=1";
				
				new Ajax.Request(url,{
					method: 'get',
					onSuccess: function(transport){
						if(transport.responseText.match(/<error>(.*)<\/error>/))
						{
							message = transport.responseText.match(/<error>(.*)<\/error>/);
							if(!message[1])
							{
								message[1] = "An unknown error occurred.";
							}
							
							alert(message[1]);
							AjaxPoll.hideOverlay();
						}
						else
						{
							AjaxPoll.hideOverlay();
							$('ajaxpoll').hide();
							$('ajaxpoll').insert({'before':transport.responseText});
							if($('ajaxpoll_back'))
							{
								$('ajaxpoll_back').observe('click', function(e){
									$('ajaxpoll').show();
									$('ajaxpoll_results').remove();
									
									Event.stop(e);
								});
							}
						}
					}
				});
				
				Event.stop(e);
			});
	}
};
Event.observe(document, 'dom:loaded', AjaxPoll.init);